//Generic test app framework
#include <string.h>
#include <stdio.h>
#include <Application.h>
#include <Window.h>
#include <MenuBar.h>
#include <MenuItem.h>
#include "WindowPositionSet.h"
#include "Colors.h"


class GenericApp : public BApplication
{
	public:
		GenericApp();
		~GenericApp();
		void RegisterWindow();
		void UnregisterWindow();
		char* GetNextDocumentWindowName();
		char* GetNextStatusWindowName();
		virtual void MessageReceived(BMessage *a_message);
		virtual void Quit();
		WindowPositionSet m_document_window_position;
		WindowPositionSet m_status_window_position;

	private:
		int32 m_number_of_windows;
};


class GenericDocumentWindow : public BWindow
{
	public:
		GenericDocumentWindow(BRect a_frame,char* a_title);
		~GenericDocumentWindow();
};


class GenericStatusWindow : public BWindow
{
	public:
		GenericStatusWindow(BRect a_frame,char* a_title);
		~GenericStatusWindow();
};


int main()
{
	new GenericApp;
	be_app->Run();
	delete be_app;
}


const uint32 NEW_DOCUMENT = 'NwDc';
const uint32 NEW_STATUS = 'NwSt';


GenericApp::GenericApp()
: BApplication("application/x-vnd.BT-Generic"),
m_document_window_position(BRect(20,50,420,450),false),
m_status_window_position(BRect(250,40,500,115),true)
{
	m_document_window_position.SetSizeLimits(200.0,100000.0,100.0,100000.0);
	BRect preferred_document_window_pos(20,50,420,450);
	//At this point, if I had stored document position preferences information in GenericApp::Quit, I would read it
	m_document_window_position.SetCurrentDefault(preferred_document_window_pos);
	new GenericDocumentWindow(m_document_window_position.GetNextUntitledWindow(),GetNextDocumentWindowName());
}


void GenericApp::RegisterWindow()
{
	atomic_add(&m_number_of_windows,1);
}


void GenericApp::UnregisterWindow()
{
	if(atomic_add(&m_number_of_windows,-1) == 1)
		//This is the last window, so user is done
		be_app->PostMessage(B_QUIT_REQUESTED);
}


void GenericApp::Quit()
{
	BRect preferred_document_window_pos = m_document_window_position.GetCurrentDefault();
	//If I wanted to remember the preferred document position and size as a setting for next
	//time, this is where I would do it.
	/*Just to avoid an unused variable warning*/ preferred_document_window_pos.left = 0;
	BApplication::Quit();
}


GenericApp::~GenericApp()
{ }


char* GenericApp::GetNextDocumentWindowName()
//Returns the name of the next document window.
//The caller will own the char array, which must be freed with delete[].
{
	static int32 counter = 1;

	char* sprintfBuffer = new char[23];
	sprintf(sprintfBuffer,"Untitled document %d",(int)atomic_add(&counter,1));
	return sprintfBuffer;
}


char* GenericApp::GetNextStatusWindowName()
//Returns the name of the next status window.
//The caller will own the char array, which must be freed with delete[].
{
	static int32 counter = 1;

	char* sprintfBuffer = new char[19];
	sprintf(sprintfBuffer,"Status window %d",(int)atomic_add(&counter,1));
	return sprintfBuffer;
}


void GenericApp::MessageReceived(BMessage *a_message)
{
	switch(a_message->what)
	{
		case NEW_DOCUMENT:
			new GenericDocumentWindow(m_document_window_position.GetNextUntitledWindow(),GetNextDocumentWindowName());	
			break;
		case NEW_STATUS:
			new GenericStatusWindow(m_status_window_position.GetNextUntitledWindow(),GetNextStatusWindowName());	
			break;
		default:
			BApplication::MessageReceived(a_message);
			break;
	}
}


GenericDocumentWindow::GenericDocumentWindow(BRect a_frame,char* a_title)
: BWindow(a_frame,a_title,B_TITLED_WINDOW,0)
{
	delete[] a_title;
	((GenericApp*)be_app)->RegisterWindow();
	SetSizeLimits(200.0,100000.0,100.0,100000.0);
	BRect view_area = Bounds();
	BMenuBar* menu_bar = new BMenuBar(view_area,NULL);
	BMenu* menu = new BMenu("File");
		BMenuItem* menu_item = new BMenuItem("New document",new BMessage(NEW_DOCUMENT),'N');
			menu_item->SetTarget(be_app);
			menu->AddItem(menu_item);
		menu_item = new BMenuItem("New status window",new BMessage(NEW_STATUS),'S');
			menu_item->SetTarget(be_app);
			menu->AddItem(menu_item);
		menu_item = new BMenuItem("Quit",new BMessage(B_QUIT_REQUESTED),'Q');
			menu_item->SetTarget(be_app);
			menu->AddItem(menu_item);
		menu_bar->AddItem(menu);
	AddChild(menu_bar);
	view_area.top = menu_bar->Frame().bottom+1.0;
	BView* filler_view = new BView(view_area,NULL,B_FOLLOW_ALL_SIDES,B_WILL_DRAW);
	filler_view->SetViewColor(White);
	AddChild(filler_view);
	Show();
}


GenericDocumentWindow::~GenericDocumentWindow()
{
	((GenericApp*)be_app)->m_document_window_position.WindowClosingSetDefault(this);
	((GenericApp*)be_app)->UnregisterWindow();
}


GenericStatusWindow::GenericStatusWindow(BRect a_frame,char* a_title)
: BWindow(a_frame,a_title,B_TITLED_WINDOW,B_NOT_RESIZABLE)
{
	delete[] a_title;
	((GenericApp*)be_app)->RegisterWindow();
	BView* filler_view = new BView(Bounds(),0,0,B_WILL_DRAW);
	filler_view->SetViewColor(BeBackgroundGrey);
	AddChild(filler_view);
	Show();
}


GenericStatusWindow::~GenericStatusWindow()
{
	((GenericApp*)be_app)->UnregisterWindow();
}
